# 👤 حسابات الإدارة - نظام إدارة الموارد البشرية

## 🔐 حسابات لوحة التحكم المركزية

### 1️⃣ **مدير لوحة التحكم الرئيسي**

```
📧 البريد الإلكتروني: admin@dashboard.com
🔐 كلمة المرور: Admin@123456
👤 الدور: مدير النظام (Super Admin)
🏢 الشركة: الشركة الرئيسية
🔗 الرابط: http://127.0.0.1:8000/super-admin/dashboard
```

### 2️⃣ **مدير النظام الافتراضي**

```
📧 البريد الإلكتروني: superadmin@example.com
🔐 كلمة المرور: password
👤 الدور: مدير النظام (Super Admin)
🏢 الشركة: الشركة الرئيسية
🔗 الرابط: http://127.0.0.1:8000/super-admin/dashboard
```

### 3️⃣ **مسؤول الشركة الافتراضي**

```
📧 البريد الإلكتروني: admin@example.com
🔐 كلمة المرور: password
👤 الدور: مسؤول (Admin)
🏢 الشركة: الشركة الرئيسية
🔗 الرابط: http://127.0.0.1:8000/dashboard
```

---

## 🎯 الصلاحيات حسب الدور

### **مدير النظام (Super Admin)**
- ✅ إنشاء وتعديل وحذف الشركات
- ✅ إدارة مستخدمي جميع الشركات
- ✅ محاكاة دخول المستخدمين
- ✅ عرض جميع البيانات
- ✅ الوصول إلى لوحة التحكم المركزية

### **مسؤول الشركة (Admin)**
- ✅ إدارة موظفي الشركة
- ✅ إدارة الرواتب والقروض
- ✅ إدارة الإجازات والحضور
- ✅ عرض بيانات الشركة فقط

### **مدير (Manager)**
- ✅ إدارة الموظفين
- ✅ تسجيل الحضور والانصراف
- ✅ الموافقة على الإجازات
- ✅ عرض بيانات فريقه

### **موظف (Employee)**
- ✅ عرض بيانته الشخصية
- ✅ طلب إجازة
- ✅ عرض راتبه

---

## 🚀 خطوات الدخول الأولى

### 1. الدخول إلى لوحة التحكم المركزية

```
الرابط: http://127.0.0.1:8000/super-admin/dashboard
البريد: admin@dashboard.com
كلمة المرور: Admin@123456
```

### 2. تغيير كلمة المرور

⚠️ **مهم جداً**: يجب تغيير كلمة المرور الافتراضية فوراً

```
1. اذهب إلى إعدادات الحساب
2. اختر "تغيير كلمة المرور"
3. أدخل كلمة المرور الحالية والجديدة
4. انقر على "حفظ"
```

### 3. إنشاء شركة جديدة

```
1. اذهب إلى: /super-admin/companies
2. انقر على "إضافة شركة جديدة"
3. أدخل بيانات الشركة
4. انقر على "حفظ"
```

### 4. إضافة مستخدمين للشركة

```
1. اختر الشركة من القائمة
2. انقر على "المستخدمون"
3. انقر على "إضافة مستخدم جديد"
4. أدخل بيانات المستخدم واختر الدور
5. انقر على "حفظ"
```

---

## 📊 المسارات الرئيسية

| المسار | الوصف |
|-------|-------|
| `/super-admin/dashboard` | لوحة التحكم الرئيسية |
| `/super-admin/companies` | إدارة الشركات |
| `/super-admin/companies/{id}/users` | إدارة مستخدمي الشركة |
| `/dashboard` | لوحة تحكم الموظف |
| `/employees` | قائمة الموظفين |
| `/payroll` | إدارة الرواتب |

---

## 🔒 نصائح الأمان

⚠️ **تغيير كلمات المرور الافتراضية فوراً**

⚠️ **استخدام كلمات مرور قوية** (حروف كبيرة + صغيرة + أرقام + رموز)

⚠️ **عدم مشاركة بيانات الدخول**

⚠️ **تفعيل HTTPS في الإنتاج**

⚠️ **مراقبة السجلات بانتظام**

---

## 📝 ملاحظات مهمة

### الحسابات الافتراضية:
- تم إنشاء 3 حسابات افتراضية للاختبار
- يجب تغيير كلمات المرور قبل الاستخدام الفعلي
- يمكن حذف الحسابات الافتراضية بعد إنشاء حسابات جديدة

### العزل بين الشركات:
- كل شركة لها بيانات منفصلة تماماً
- المستخدمون لا يرون بيانات شركات أخرى
- السوبر أدمن فقط يرى جميع البيانات

### الدعم والمساعدة:
- راجع `MULTI_TENANCY_GUIDE.md` للمزيد من المعلومات
- راجع `INSTALLATION.md` لخطوات التثبيت
- راجع `SUPER_ADMIN_SUMMARY.md` لملخص المشروع

---

## 🎓 أمثلة الاستخدام

### إنشاء مستخدم جديد برمجياً:

```php
use App\Models\User;
use App\Models\Company;
use Illuminate\Support\Facades\Hash;

$company = Company::find(1);

$user = User::create([
    'name' => 'اسم المستخدم',
    'email' => 'user@example.com',
    'password' => Hash::make('password'),
    'company_id' => $company->id,
    'role' => 'admin',
    'status' => 'active',
]);
```

### تغيير دور المستخدم:

```php
$user = User::find(1);
$user->update(['role' => 'manager']);
```

### تعطيل حساب:

```php
$user = User::find(1);
$user->update(['status' => 'inactive']);
```

---

**آخر تحديث**: 7 ديسمبر 2025
**الإصدار**: 1.0.0
